rm(list=ls())
set.seed(2)

library(SpatialExtremes)
library(censgauss)





#Reading the data
source('read-data.R')

# defining function for indirect inference
indirect.inference<-function(par.ori,data.ori,coords,prob,n.sim)
  
{
  
  
  
  
  
  #simulation from SPT-AR MODEL (with maxstable errors)
  
  
  alpha<-exp(par.ori[1])/(1+exp(par.ori[1]))
  range<-exp(par.ori[2])
  smooth<-exp(par.ori[3])
  
  
  if (smooth<1.5){
    
    cov.mod<-"brown" # "whitmat", "cauchy", "powexp" and "bessel" for Schlater
    # brown for Brown-Resnick
    
    set.seed(2)
    
    data.sim <- rmaxstab(n.sim, coord=coords, cov.mod = cov.mod, nugget = 0,
                         range = range, smooth = smooth, grid = FALSE)
    data.sim<-sqrt((1-alpha^2))*qnorm(exp(-1/data.sim))
    data.sim<-apply(t(data.sim),1,filter, filter=alpha,method="recursive",sides=1,init=0)
    
    
    #initial values for par.gauss
    
    corrmodel<-9 # stable-stable separable model
    # phi_1, phi_2 (range) alpha, beta, gamma (smooth)
    
    phi2.ini<- -1/log(alpha)
    init.phi<-c(4000  ,  phi2.ini  ,  smooth ,   1)
    mask.phi<-c(TRUE,FALSE,FALSE,FALSE)
    
    
    
    # anisotropic parameters
    alpha.ani<-0
    lambda.ani<-1
    init.aniso<-c(alpha.ani,lambda.ani)
    mask.aniso<-c(FALSE,FALSE)
    
    # omega (velocity) in the notation of  Huser and Davison (2014)
    init.velocity<-c(0, 0)
    mask.velocity<-c(FALSE,FALSE)
    
    
    ncores<-10 # set the number of cores.
    delta.t<-2 # C_T
    delta.s<-quantile(dist(coords),1) # C_S=max-dist
    
    
    #subsample for initial values
    n.subsample<-4000
    subsample<-data.sim[1:n.subsample,]
    
    #threshold on  N(0,1) scale
    threshold<-qnorm(prob)
    
    
    fitcp.ini<-spt.censgauss.fit(ydata=subsample, 
                                 coords = coords,  init.phi=init.phi, init.aniso=init.aniso, init.velocity=init.velocity,
                                 delta.s= delta.s ,delta.t=delta.t, threshold = threshold,
                                 mask.phi=mask.phi, mask.aniso=mask.aniso, mask.velocity=mask.velocity,
                                 ncores = ncores, corrmodel = corrmodel, maxit.NM=1000)
    
    
    
    par.gauss.ini<-c(fitcp.ini$thetahat[1],phi2.ini,smooth,1)
    
    
    
    #estimation of gaussian copula using initial values
    
    
    mask.phi<-c(TRUE,TRUE,TRUE,FALSE)
    delta.t<-4 # C_T
    
    fitcp<-spt.censgauss.fit(ydata=data.sim, 
                             coords = coords,  init.phi=par.gauss.ini, init.aniso=init.aniso, init.velocity=init.velocity,
                             delta.s= delta.s ,delta.t=delta.t, threshold = threshold, 
                             mask.phi=mask.phi, mask.aniso=mask.aniso, mask.velocity=mask.velocity,
                             ncores = ncores, corrmodel = corrmodel,maxit.NM=2000)
    
    
    par.gauss<-fitcp$thetahat
    par.compl.gaus<-fitcp$param
    
    
    
    # calculating the auxiliary -log-likelihood on original (transformed) data
    
    mask <- c(mask.aniso, mask.velocity, mask.phi)
    
    nsites<-ncol(data.ori)
    ntimes<-nrow(data.ori)
    xy<-rep(1,ntimes)%x%as.matrix(coords)
    xcoords<-xy[,1]
    ycoords<-xy[,2]
    tcoords<-(1:ntimes)%x%rep(1,nsites)
    ydata<-t(data.ori)
    y<-as.numeric(ydata)
    
    delta<-c(delta.s,delta.t)
    
    
    f.value<-PLneg.spt.censgauss(par.gauss,y=y, threshold=threshold,
                                xcoords=xcoords, ycoords=ycoords, tcoords=tcoords,
                                delta=delta, param=par.compl.gaus, mask=mask, ncores=ncores,nsites=nsites,
                                ntimes=ntimes, corrmodel=corrmodel)
    
  }
  else
  {
    f.value<- Inf
  }
  
  
  
  f.value
}



# transform data to normal scale with empirical d.f.
rankdata<-apply(alldata,2,rank,ties.method="random")
n.ori<-nrow(alldata)

data.ori<-qnorm(rankdata/(n.ori+1))


prob<-0.90 # threshold level p
n.sim<-40000 #number of simulations at each ind.inf. step (M)

#starting values for par.ori=(alpha,range,smooth)
#with par.ori[1]=alpha, par.ori[2]=range (psi_1), par.ori[3]=smooth (psi_2)
par.ori<-NULL
par.ori[1]<-0.5
par.ori[2]<-500
par.ori[3]<-0.7


#REPARAMETRIZATION:
#par[1]=log(alpha/(1-alpha))
#par[2]=log(range)
#par[3]=log(smooth)

par.ini<-NULL
par.ini[1]<-log(par.ori[1]/(1-par.ori[1]))
par.ini[2]<-log(par.ori[2])
par.ini[3]<-log(par.ori[3])

# Optimizing with respect to par.ini=theta
fit.indirect<-optim(par=par.ini, fn=indirect.inference, data.ori=data.ori, 
                      coords=coords,prob=prob,n.sim=n.sim,
                      method="Nelder-Mead",control=list(maxit=800))


#saving the estimates
save(fit.indirect,file="NLRR-maxstable.out")







